<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\Bots */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Bots', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="bots-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'bot',
            'country',
            'arch',
            'cname',
            'path',
            'uname',
            'comps',
            'av:ntext',
            'group',
            'soft',
            'status',
            'created_at',
            'updated_at',
            'ip',
            'locale',
            'tz',
            'ps:ntext',
            'source',
            'os',
            'comment:ntext',
            'user',
            'busy',
            'trust',
            'net',
            'domain',
            'osbuild',
        ],
    ]) ?>

</div>
